/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * max98088.h -- MAX98088 ALSA SoC Audio driver
 *
 * Copyright 2010 Maxim Integrated Products
 */

#ifndef _MAX98088_H
#define _MAX98088_H

/* MAX98088 Registers Definition */
#include <linux/bitops.h>
#define M98088_REG_IRQ_STATUS		0x00
#define M98088_REG_MIC_STATUS		0x01
#define M98088_REG_JACK_STAUS		0x02
#define M98088_REG_BATTERY_VOLTAGE	0x03
#define M98088_REG_IRQ_ENABLE		0x0f
#define M98088_REG_SYS_CLK		0x10
#define M98088_REG_DAI1_CLKMODE		0x11
#define M98088_REG_DAI1_CLKCFG_HI	0x12
#define M98088_REG_DAI1_CLKCFG_LO	0x13
#define M98088_REG_DAI1_FORMAT		0x14
#define M98088_REG_DAI1_CLOCK		0x15
#define M98088_REG_DAI1_IOCFG		0x16
#define M98088_REG_DAI1_TDM		0x17
#define M98088_REG_DAI1_FILTERS		0x18
#define M98088_REG_DAI2_CLKMODE		0x19
#define M98088_REG_DAI2_CLKCFG_HI	0x1a
#define M98088_REG_DAI2_CLKCFG_LO	0x1b
#define M98088_REG_DAI2_FORMAT		0x1c
#define M98088_REG_DAI2_CLOCK		0x1d
#define M98088_REG_DAI2_IOCFG		0x1e
#define M98088_REG_DAI2_TDM		0x1f
#define M98088_REG_DAI2_FILTERS		0x20
#define M98088_REG_SRC			0x21
#define M98088_REG_MIX_DAC		0x22
#define M98088_REG_MIX_ADC_LEFT		0x23
#define M98088_REG_MIX_ADC_RIGHT	0x24
#define M98088_REG_MIX_HP_LEFT		0x25
#define M98088_REG_MIX_HP_RIGHT		0x26
#define M98088_REG_MIX_HP_CNTL		0x27
#define M98088_REG_MIX_REC_LEFT		0x28
#define M98088_REG_MIX_REC_RIGHT	0x29
#define M98088_REG_MIC_REC_CNTL		0x2a
#define M98088_REG_MIX_SPK_LEFT		0x2b
#define M98088_REG_MIX_SPK_RIGHT	0x2c
#define M98088_REG_MIX_SPK_CNTL		0x2d
#define M98088_REG_LVL_SIDETONE		0x2e
#define M98088_REG_LVL_DAI1_PLAY	0x2f
#define M98088_REG_LVL_DAI1_PLAY_EQ	0x30
#define M98088_REG_LVL_DAI2_PLAY	0x31
#define M98088_REG_LVL_DAI2_PLAY_EQ	0x32
#define M98088_REG_LVL_ADC_L		0x33
#define M98088_REG_LVL_ADC_R		0x34
#define M98088_REG_LVL_MIC1		0x35
#define M98088_REG_LVL_MIC2		0x36
#define M98088_REG_LVL_INA		0x37
#define M98088_REG_LVL_INB		0x38
#define M98088_REG_LVL_HP_L		0x39
#define M98088_REG_LVL_HP_R		0x3a
#define M98088_REG_LVL_REC_L		0x3b
#define M98088_REG_LVL_REC_R		0x3c
#define M98088_REG_LVL_SPK_L		0x3d
#define M98088_REG_LVL_SPK_R		0x3e
#define M98088_REG_MICAGC_CFG		0x3f
#define M98088_REG_MICAGC_THRESH	0x40
#define M98088_REG_SPKDHP		0x41
#define M98088_REG_SPKDHP_THRESH	0x42
#define M98088_REG_SPKALC_COMP		0x43
#define M98088_REG_PWRLMT_CFG		0x44
#define M98088_REG_PWRLMT_TIME		0x45
#define M98088_REG_THDLMT_CFG		0x46
#define M98088_REG_CFG_AUDIO_IN		0x47
#define M98088_REG_CFG_MIC		0x48
#define M98088_REG_CFG_LEVEL		0x49
#define M98088_REG_CFG_BYPASS		0x4a
#define M98088_REG_CFG_JACKDET		0x4b
#define M98088_REG_PWR_EN_IN		0x4c
#define M98088_REG_PWR_EN_OUT		0x4d
#define M98088_REG_BIAS_CNTL		0x4e
#define M98088_REG_DAC_BIAS1		0x4f
#define M98088_REG_DAC_BIAS2		0x50
#define M98088_REG_PWR_SYS		0x51
#define M98088_REG_DAI1_EQ_BASE		0x52
#define M98088_REG_DAI2_EQ_BASE		0x84
#define M98088_REG_DAI1_BIQUAD_BASE	0xb6
#define M98088_REG_DAI2_BIQUAD_BASE	0xc0
#define M98088_REG_REV_ID		0xff

#define M98088_REG_CNT			(0xff + 1)

/* MAX98088 Registers Bit Fields */

/* M98088_REG_11_DAI1_CLKMODE, M98088_REG_19_DAI2_CLKMODE */
#define M98088_CLKMODE_MASK		0xFF

/* M98088_REG_14_DAI1_FORMAT, M98088_REG_1C_DAI2_FORMAT */
#define M98088_DAI_MAS			BIT(7)
#define M98088_DAI_WCI			BIT(6)
#define M98088_DAI_BCI			BIT(5)
#define M98088_DAI_DLY			BIT(4)
#define M98088_DAI_TDM			BIT(2)
#define M98088_DAI_FSW			BIT(1)
#define M98088_DAI_WS			BIT(0)

/* M98088_REG_15_DAI1_CLOCK, M98088_REG_1D_DAI2_CLOCK */
#define M98088_DAI_BSEL64		BIT(0)
#define M98088_DAI_OSR64		BIT(6)

/* M98088_REG_16_DAI1_IOCFG, M98088_REG_1E_DAI2_IOCFG */
#define M98088_S1NORMAL			BIT(6)
#define M98088_S2NORMAL			(2 << 6)
#define M98088_SDATA			(3 << 0)

/* M98088_REG_18_DAI1_FILTERS, M98088_REG_20_DAI2_FILTERS */
#define M98088_DAI_DHF			BIT(3)

/* M98088_REG_22_MIX_DAC */
#define M98088_DAI1L_TO_DACL		BIT(7)
#define M98088_DAI1R_TO_DACL		BIT(6)
#define M98088_DAI2L_TO_DACL		BIT(5)
#define M98088_DAI2R_TO_DACL		BIT(4)
#define M98088_DAI1L_TO_DACR		BIT(3)
#define M98088_DAI1R_TO_DACR		BIT(2)
#define M98088_DAI2L_TO_DACR		BIT(1)
#define M98088_DAI2R_TO_DACR		BIT(0)

/* M98088_REG_2A_MIC_REC_CNTL */
#define M98088_REC_LINEMODE		BIT(7)
#define M98088_REC_LINEMODE_MASK	BIT(7)

/* M98088_REG_2D_MIX_SPK_CNTL */
#define M98088_MIX_SPKR_GAIN_MASK       (3 << 2)
#define M98088_MIX_SPKR_GAIN_SHIFT      2
#define M98088_MIX_SPKL_GAIN_MASK       (3 << 0)
#define M98088_MIX_SPKL_GAIN_SHIFT      0

/* M98088_REG_2F_LVL_DAI1_PLAY, M98088_REG_31_LVL_DAI2_PLAY */
#define M98088_DAI_MUTE			BIT(7)
#define M98088_DAI_MUTE_MASK		BIT(7)
#define M98088_DAI_VOICE_GAIN_MASK      (3 << 4)
#define M98088_DAI_ATTENUATION_MASK     (0xf << 0)
#define M98088_DAI_ATTENUATION_SHIFT    0

/* M98088_REG_35_LVL_MIC1, M98088_REG_36_LVL_MIC2 */
#define M98088_MICPRE_MASK		(3 << 5)
#define M98088_MICPRE_SHIFT		5

/* M98088_REG_3A_LVL_HP_R */
#define M98088_HP_MUTE			BIT(7)

/* M98088_REG_3C_LVL_REC_R */
#define M98088_REC_MUTE			BIT(7)

/* M98088_REG_3E_LVL_SPK_R */
#define M98088_SP_MUTE			BIT(7)

/* M98088_REG_48_CFG_MIC */
#define M98088_EXTMIC_MASK		(3 << 0)
#define M98088_DIGMIC_L			BIT(5)
#define M98088_DIGMIC_R			BIT(4)

/* M98088_REG_49_CFG_LEVEL */
#define M98088_VSEN			BIT(6)
#define M98088_ZDEN			BIT(5)
#define M98088_EQ2EN			BIT(1)
#define M98088_EQ1EN			BIT(0)

/* M98088_REG_4C_PWR_EN_IN */
#define M98088_INAEN			BIT(7)
#define M98088_INBEN			BIT(6)
#define M98088_MBEN			BIT(3)
#define M98088_ADLEN			BIT(1)
#define M98088_ADREN			BIT(0)

/* M98088_REG_4D_PWR_EN_OUT */
#define M98088_HPLEN			BIT(7)
#define M98088_HPREN			BIT(6)
#define M98088_HPEN			(BIT(7) | BIT(6))
#define M98088_SPLEN			BIT(5)
#define M98088_SPREN			BIT(4)
#define M98088_RECEN			BIT(3)
#define M98088_DALEN			BIT(1)
#define M98088_DAREN			BIT(0)

/* M98088_REG_51_PWR_SYS */
#define M98088_SHDNRUN			BIT(7)
#define M98088_PERFMODE			BIT(3)
#define M98088_HPPLYBACK		BIT(2)
#define M98088_PWRSV8K			BIT(1)
#define M98088_PWRSV			BIT(0)

#endif
