/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//BEGIN INCLUDES
#include "toolsinfodialog.h"
#include <klistview.h>
//#include <qlistviewitem.h>
#include <qpixmap.h>
#include <kglobal.h>
#include <qstring.h>
#include <kiconloader.h>
#include <iostream>
#include <klocale.h>
#include <qcursor.h>
//END INCLUDES

ToolsInfoDialog::ToolsInfoDialog(KVpncConfig *GlobalConfig, QWidget *parent, const char *)
		:KDialogBase( parent, "Tool_information", true, "",
		              KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	main = new ToolsInfoWidgetBase(this);
	setMainWidget(main);
	main->InfoListView->setMinimumSize(main->InfoListView->sizeHint());

	QPixmap ok_icon = KGlobal::iconLoader()->loadIcon( "button_ok", KIcon::NoGroup, 16 );
	QPixmap wrong_icon = KGlobal::iconLoader()->loadIcon( "button_cancel", KIcon::NoGroup, 16 );
	ToolInfo *tool=0;
	main->InfoListView->setSorting(1);

	setCursor(Qt::BusyCursor );

	for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
	{
// 		std::cout << "tool: " << tool->Name.ascii() << std::endl;
		// 		std::cout << "Version: " << tool->Version << std::endl;
		// 		std::cout << "Path: " << tool->PathToExec << std::endl << std::endl;
		QString state="";
		QString usability="";
		QString comment="";

		tool->programsInPath =  GlobalConfig->programsInPath;

		tool->collectToolInfo();

		if (!tool->PathToExec.isEmpty() && QFile (tool->PathToExec).exists() && QFileInfo(tool->PathToExec).isFile() )
		{
			state=i18n("Found");
			if (tool->Name == "vpnc")
			{
				if ( tool->Version.find("3.3",0,-1) > -1)
				{
					usability=i18n("full");
				}
				else if ( tool->Version.find("3.2",0,-1) > -1)
				{
					usability=i18n("limited");
					comment=i18n("no split DNS support");
				}
				else if ( tool->Version.find("2.",0,-1) > -1)
				{
					usability=i18n("basic");
					comment=i18n("no NAT-T, IPSec over IP, no split DNS support");
				}
			}
			else if (tool->Name == "ipsec")
			{
				// version is like this: "Openswan U2.4.4/K2.6.15" or "strongSwan U2.4.4/K2.6.15"
				QString realversion=tool->Version.section(' ',1,1).section('/',0,0).right(tool->Version.section(' ',1,1).section('/',0,0).length()-1);
				int majorversion = realversion.section('.',0,0).toInt();
				int minorversion = realversion.section('.',1,1).toInt();
				int subminorversion = realversion.section('.',2,2).toInt();
				QString realtype=tool->Version.section(' ',0,0).lower();

				if ( tool->Version.contains("Openswan"))
				{
					comment="Openswan";
					comment+=", "+i18n("kernel %1 support").arg("2.6");
					comment+=", "+i18n("smartcard support");
				}
				else if ( tool->Version.contains("strongSwan"))
				{
					comment="strongSwan";
					comment+=", "+i18n("no aggressive mode");
					comment+=", "+i18n("kernel %1 support").arg("2.4");
					if (!(majorversion <= 2 && minorversion <= 8 && subminorversion <= 1))
						comment+=", "+i18n("kernel %1 support").arg("2.6");
					comment+=", "+i18n("smartcard support");
				}
				else
					comment+="FreeS/WAN";


				if ( realversion.find("2.",0,-1) > -1)
					usability=i18n("full");
				else if ( realversion.find("1.",0,-1) > -1)
				{
					usability=i18n("limited");
					comment=+", "+i18n("no aggressive mode");
				}
				else
					usability=i18n("unknown");

			}
			else if (tool->Name == "racoon")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "openvpn")
			{
				if ( tool->Version.find("2.",0,-1) > -1)
				{
					usability=i18n("full");
// 					int major=tool->Version.section('.',0,0).toInt();
// 					int minor=tool->Version.section('.',1,1).toInt();
// 					int subminor=tool->Version.section('.',2,2).toInt();

// 					if ( major >= 2 && minor >= 1)
						if (tool->Capabilities.find( i18n("pkcs11 support"), 0, FALSE ) > -1 )
						{
							if (!comment.isEmpty())
								comment+=", ";
							comment+=i18n("smartcard support");
						}
				}
				else if ( tool->Version.find("1.",0,-1) > -1)
					//else
					usability=i18n("limited");
			}
			else if (tool->Name == "pppd")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "pptp")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "kill")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "ip")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "ifconfig")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else if (tool->Name == "route")
			{
				//if ( tool->Version.find("2.",0,-1) > -1)
				usability=i18n("full");
				//else if ( tool->Version.find("2.",0,-1) > -1)
				//	usability=i18n("limited");
			}
			else
			{
				// other tools
				usability=i18n("full");
			}
		}
		else
		{
			state=i18n("Not found");
			usability=i18n("none");
		}

// 		std::cout << "Tool: " << tool->Name.ascii() << " Path: "<< tool->PathToExec.ascii() << " Version: " << tool->Version.ascii() << " Found: " << state.ascii() << std::endl;

		QListViewItem *item = new QListViewItem(main->InfoListView, tool->Name,state, tool->Version, tool->PathToExec, usability, comment);
		if (tool->found)
			item->setPixmap(1,ok_icon);
		else
			item->setPixmap(1,wrong_icon);
		main->InfoListView->insertItem(item);

	}
	this->resize(800,600);
	main->InfoListView->resize(main->InfoListView->sizeHint());
	main->resize(main->sizeHint());
	//this->resize(sizeHint());

	setCursor(Qt::ArrowCursor );
}

#include "toolsinfodialog.moc"
